<?php
include_once 'databases.php'; // Include database connection

if (isset($_GET['packageid'])) {
    $packageid = $_GET['packageid'];

    // Query for package details
    $sql = "SELECT * FROM package WHERE packageid = ?";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("s", $packageid);
    $stmt->execute();
    $result = $stmt->get_result();
    $package = $result->fetch_assoc();

    if ($package) {
        // Dynamically fetch the background image URL
        $backgroundImageUrl = 'https://learninghubbd.online/al-waqiah-final/admin/storage/app/public/' . htmlspecialchars($package['image']);

        // HTML Output with no margin/padding, but margin on both sides for the outer div
        echo "<div style='m-0 p-0'>
                <div class=''>
                    <div class='bg-img' style='background-image: url(\"$backgroundImageUrl\");'></div>
                    <div class='single-pricing-solari-area'>
                        <span class='pre-title'>" . htmlspecialchars($package['packageName']) . "</span>
                        <div class='days'>৯ <span class='day'>দিন</span></div>
                        <div class='spacer'></div>
                        <hr>
                        <div class='pricing-opportunity-wrapper'>
            ";

        // Fetch features
        $features_sql = "SELECT description, image FROM packagefeatures WHERE packageid = ?";
        $features_stmt = $connection->prepare($features_sql);
        $features_stmt->bind_param("s", $packageid);
        $features_stmt->execute();
        $features_result = $features_stmt->get_result();

        echo "<ul style='list-style-type: none; margin: 0; padding: 0;'>";
        while ($feature = $features_result->fetch_assoc()) {
            // Dynamic URL for feature image
            $featureImageUrl = 'https://learninghubbd.online/al-waqiah-final/admin/storage/app/public/' . htmlspecialchars($feature['image']);
            echo "<li> <img src='" . $featureImageUrl . "' alt='' style='width: 20px; height: 20px;'> " . htmlspecialchars($feature['description']) . "</li>";
        }
        echo "</ul>";

        echo "
        </div>
        <div class='pricebox'>
            <h4 class='title-price'>৳ " . htmlspecialchars($package['price']) . " <span style='color:#4B5563'>হতে শুরু</span></h4>
        </div>
    </div>
</div>
";
        // Close the HTML output
        echo "</div>";  // Close the main div
    } else {
        echo "<p>Package not found.</p>";
    }
}
?>
