<?php
include 'header.php';
include_once 'databases.php'; // Make sure this includes the correct database connection
?>

<!-- Custom CSS for styling form rows and borders -->
<style>
    /* Row Layout Styling */
    .form-row {
        display: flex;
        flex-wrap: wrap;
        
    }

    /* Ensuring form-group fields are aligned in two columns */
    .form-group {
        display: flex;
        flex-direction: column;
        
    }

    /* Add border to input, select, and textarea fields */
    .form-group input,
    .form-group select,
    .form-group textarea {
        width: 100%;
        box-sizing: border-box;
        border: 1px solid #ccc; /* Add border */
        padding:0px 10px ; /* Add padding inside input fields */
        border-radius: 4px; /* Rounded corners */
    }

    /* Add focus border color when input is focused */
    .form-group input:focus,
    .form-group select:focus,
    .form-group textarea:focus {
        border-color: #007bff; /* Blue border when focused */
        outline: none; /* Remove default focus outline */
    }

    .form-row .form-group {
        padding: 0 10px;
        flex-basis: 50%; /* Take up 50% of the row space */
    }

    /* Responsive adjustment for smaller screens */
    @media (max-width: 768px) {
        .form-row .form-group {
            flex-basis: 100%; /* Full width on small screens */
        }
    }

    /* Ensure input and textarea are properly aligned */
    .form-group label {
        font-weight: bold;
        
    }

    /* Additional space between rows */
    .form-row + .form-row {
        
    }
</style>
<div class='banner-two-swiper-start'>
    <div class='swiper mySwiper-banner-2'>
        <div class='swiper-wrapper'>
            <div class='swiper-slide'>
                <!-- Single Swiper Style -->
                <div class='banner-two-main-wrapper-solaric'>
                  
                    <div class='container'>
                        <div class='row'>
                            <div class='col-lg-6'>
                                <div class='banner-solari-2-content ptb--200 ptb_sm--250'>
                                    <h1 class='banner-title'>
                                        নির্বিঘ্ন, শান্তিপূর্ণ ভ্রমণে হবে<br>পরিপূর্ন হজ্জ্ব ও উমরাহ
                                    </h1>
                                    <div class='button-solari-banner-area'>
                                        <a href='https://learninghubbd.online/al-waqiah-final/packages.php' class='rts-btn btn-primary'>বিস্তারিত জানুন</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 banner-two-swiper-start">

                            </div>
                        </div>
                    </div>
                </div>
                <!-- Single Swiper Style End -->
            </div>
            <div class='swiper-slide'>
                <!-- Single Swiper Style -->
                <div class='banner-two-main-wrapper-solaric two'>
                   
                    <div class='container'>
                        <div class='row'>
                            <div class='col-lg-6'>
                                <div class='banner-solari-2-content ptb--200 ptb_sm--250'>
                                    <h1 class='banner-title'>
                                        দারুন সব সুযোগসুবিধা নিয়ে<br>
                                        সেরা উমরাহ ও হজ্জ প্যাকেজ
                                    </h1>
                                    <div class='button-solari-banner-area'>
                                        <a href='https://learninghubbd.online/al-waqiah-final/packages.php' class='rts-btn btn-primary'>প্যাকেজ সম্পর্কে জানুন </a>
                                    </div>
                                </div>
                            </div>
                            <div class='col-lg-6'>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- Single Swiper Style End -->
            </div>
        </div>
        <div class='swiper-pagination-b2'></div>
    </div>
</div>







<!-- Modal -->
<div class="modal fade" id="customModal" tabindex="-1" aria-labelledby="customModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            
            <div class="modal-body">
                <h4 class="text-center ">Customize Package </h4>
            <hr>
                <form id="packageForm" action="submit_form.php" method="POST">
                    <!-- Row 1 -->
                    <div class="form-group px-3">
                            <label for="name">Name:</label>
                            <input type="text" class="form-control" id="name" name="name" style="height: 35px!important;" required>
                        </div>
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="phone">Phone:</label>
                            <input type="number" class="form-control" id="phone" name="phone" style="height: 35px!important;" required>
                        </div>
                        <div class="form-group col-6">
                            <label for="date">Date:</label>
                            <input type="date" class="form-control" id="date" name="date" style="height: 35px!important;" required>
                        </div>
                    </div>
                    
                    <div class="form-group px-3">
                            <label for="hotel_makka">Preferred Hotel (Makka):</label>
                            <input type="text" class="form-control" id="hotel_makka" name="hotel_makka" style="height: 35px!important;" required>
                        </div>
<div class="form-group px-3">
                            <label for="hotel_madina">Preferred Hotel (Madina):</label>
                            <input type="text" class="form-control" id="hotel_madina" name="hotel_madina" style="height: 35px!important;" required>
                        </div>
                    <!-- Row 2 -->
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="airlines">Airlines:</label>
                            <select class="form-control " id="airlines" name="airlines" style="height: 35px!important;" required>
                                <option value="Airline 1">Airline 1</option>
                                <option value="Airline 2">Airline 2</option>
                                <option value="Airline 3">Airline 3</option>
                            </select>
                        </div>
                        <div class="form-group col-6">
                            <label for="transport">Preferred Transport:</label>
                            <input type="text" class="form-control" id="transport" name="transport" style="height: 35px!important;" required>
                        </div>
                    </div>


                    <div class="form-group px-3">
  <label for="jiarah">Jiarah (Additional Spots):</label>
  <input type="text" class="form-control" id="jiarah" name="jiarah" style="height: 70px!important;">
</div>
                   
                      
                 

                    <!-- Row 5 -->
                   <div class="row g-3 px-3">
  <div class="col-md-3 form-group">
    <label for="adult" class="form-label">Adult:</label>
    <input type="number" class="form-control border border-muted" id="adult" name="adult" style="height: 35px!important;" required>
  </div>

  <div class="col-md-3 form-group">
    <label for="child" class="form-label">Child:</label>
    <input type="number" style="height: 35px!important;" class="form-control border border-muted" id="child" name="child" required>
  </div>

  <div class="col-md-3 form-group">
    <label for="male" class="form-label">Male:</label>
    <input type="number" style="height: 35px!important;" class="form-control border border-muted" id="male" name="male" required>
  </div>

  <div class="col-md-3 form-group">
    <label for="female" class="form-label">Female:</label>
    <input type="number" style="height: 35px!important;" class="form-control border border-muted" id="female" name="female" required>
  </div>
</div>

                  
                        
                        <div class="form-group px-3">
                            <label for="food">Food:</label>
                            <input type="text" class="form-control " id="food" name="food" style="height: 35px!important;" required>
                        </div>
              
                   

<div class="d-flex">
<button type="submit" class="btn btn-primary rts-btn " style="margin:10px;">Submit</button>
                    <button type="button" class="close btn btn-primary rts-btn" data-dismiss="modal" aria-label="Close" style="margin:10px;">
                    Close
                </button>
</div>
                    
                </form>
            </div>
        </div>
    </div>
</div>





<!-- About Video Section Start -->
<div class="container py-5">
    <div class="row g-4 justify-content-center">
        <!-- Video 1 -->
        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="position-relative">
                <img src="assets/images/about/22.png" class="img-fluid w-100 rounded" alt="Video Thumbnail">
                <a href="#"
                    class="position-absolute top-50 start-50 translate-middle btn btn-light rounded-circle p-4" 
                    data-bs-toggle="modal" data-bs-target="#videoModal1">
                    <i class="fas fa-play fs-3 text-dark"></i>
                </a>
            </div>
            <h6 class="m-3">আল ওয়াকিয়াহ দিচ্ছে উমরাহ যাত্রার সহজ প্রক্রিয়া</h6>
        </div>

        <!-- Video 2 -->
        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="position-relative">
                <img src="assets/images/about/22.png" class="img-fluid w-100 rounded" alt="Video Thumbnail">
                <a href="#"
                    class="position-absolute top-50 start-50 translate-middle btn btn-light rounded-circle p-4" 
                    data-bs-toggle="modal" data-bs-target="#videoModal2">
                    <i class="fas fa-play fs-3 text-dark"></i>
                </a>
            </div>
             <h6 class="m-3">আল ওয়াকিয়াহ দিচ্ছে উমরাহ যাত্রার সহজ প্রক্রিয়া<
        </div>

        <!-- Video 3 -->
        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="position-relative">
                <img src="assets/images/about/22.png" class="img-fluid w-100 rounded" alt="Video Thumbnail">
                <a href="#"
                    class="position-absolute top-50 start-50 translate-middle btn btn-light rounded-circle p-4" 
                    data-bs-toggle="modal" data-bs-target="#videoModal3">
                    <i class="fas fa-play fs-3 text-dark"></i>
                </a>
            </div>
            <h6 class="m-3">আল ওয়াকিয়াহ দিচ্ছে উমরাহ যাত্রার সহজ প্রক্রিয়া<
        </div>
    </div>
</div>
<!-- About Video Section End -->

<!-- Modal for Video 1 -->
<div class="modal fade "  id="videoModal1" tabindex="-1" aria-labelledby="videoModalLabel1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered p-0">
        <div class="modal-content  p-0">
            <div class="modal-header position-relative  p-0">
                <button type="button" class="btn-close position-absolute top-0 end-0 m-2 close-btn-red" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <iframe width="100%" height="300" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Video 2 -->
<div class="modal fade" id="videoModal2" tabindex="-1" aria-labelledby="videoModalLabel2" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered p-0">
        <div class="modal-content p-0">
            <div class="modal-header position-relative p-0">
                <button type="button" class="btn-close position-absolute top-0 end-0 m-2 close-btn-red" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <iframe width="100%" height="300" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Video 3 -->
<div class="modal fade" id="videoModal3" tabindex="1" aria-labelledby="videoModalLabel3" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered p-0">
        <div class="modal-content p-0">
            <div class="modal-header position-relative p-0">
                <button type="button" class="btn-close position-absolute top-0 end-0 m-2 close-btn-red" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <iframe width="100%" height="300" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
    </div>
</div>

<style>
    /* Ensure the close button is floating on the top-right without affecting layout */
    .close-btn-red {
        background-color: red; /* Red color for the close button */
        border: none; /* Remove any border */
        padding: 0; /* Remove padding */
        color: white; /* White icon color */
        font-size: 18px; /* Font size for the 'X' icon */
        z-index: 2;
    }

    /* Optional: Add hover effect */
    .close-btn-red:hover {
        background-color: darkred;
    }
</style>








<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="mb-3">প্যাকেজ সমূহ</h2>
        <p>আপনার পছন্দের প্যাকেজটি নির্বাচন করুন।</p>
    </div>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs d-flex justify-content-center align-items-center" id="myTab" role="tablist">
        <li class="nav-item  rounded-4" role="presentation">
            <button class="nav-link active p-4 fw-bold fs-3" id="umrah-tab" data-bs-toggle="tab" data-bs-target="#umrah"
                type="button" role="tab" aria-controls="umrah" aria-selected="true">
                <span> উমরাহ প্যাকেজ </span>
            </button>
        </li>
        <li class="nav-item rounded-4 mx-4 " role="presentation">
            <button class="nav-link p-4 fw-bold fs-3" id="hajj-tab" data-bs-toggle="tab" data-bs-target="#hajj"
                type="button" role="tab" aria-controls="hajj" aria-selected="false">
                <span> হজ্জ প্যাকেজ </span>
            </button>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content" id="myTabContent">
        <!-- উমরাহ প্যাকেজ সমূহ Content -->
        <div class="tab-pane fade show active" id="umrah" role="tabpanel" aria-labelledby="umrah-tab">

           <div class="row gap-5 mt-4">
    <?php
        // Query for Umrah packages
        $sql = "SELECT * FROM package WHERE packageType = 'umrah'";
        $result = $connection->query($sql);
        while ($row = $result->fetch_assoc()) {
            $packageid = $row['packageid'];
            $features_sql = "SELECT description, image FROM packagefeatures WHERE packageid = ?";
            $features_stmt = $connection->prepare($features_sql);
            $features_stmt->bind_param("s", $packageid);
            $features_stmt->execute();
            $features_result = $features_stmt->get_result();
            
            // Assuming 'image' column in 'package' table contains the relative image path
            $imageUrl = 'https://learninghubbd.online/al-waqiah-final/admin/storage/app/public/' . htmlspecialchars($row['image']);
            
            echo "
            <div class='col-lg-6 col-md-6 col-sm-12 w-sm-100 responsive-div'>
                <div class='bg-img' style='background-image: url(\"$imageUrl\");'></div>
                <div class='single-pricing-solari-area'>
                    <span class='pre-title'>" . htmlspecialchars($row['packageName']) . "</span>
                    <div class='days'>৯ <span class='day'>দিন</span></div>
                    <div class='spacer'></div>
                    <hr>
                    <div class='pricing-opportunity-wrapper' style='margin-left:20px'>
            ";

            while ($feature = $features_result->fetch_assoc()) {
                // Full image URL for feature images
                $featureImageUrl = 'https://learninghubbd.online/al-waqiah-final/admin/storage/app/public/' . htmlspecialchars($feature['image']);
                echo "
                    <div class='single d-flex align-items-center' style='margin-bottom: 7px'>
                        <div class='icon-container'>
                            <img src='" . $featureImageUrl . "' alt='Feature image' class='feature-icon' style='height: 21px; width: 21px;' />
                        </div>
                        <p class='packagetxt'>" . htmlspecialchars($feature['description']) . "</p>
                    </div>
                ";
            }

            echo "
                    </div>
                    <div class='m-top-3'>
                        <div class='pricebox mt-3'>
                            <h4 class='title-price'>৳ " . htmlspecialchars($row['price']) . " <span style='color:'#4B5563'>হতে শুরু</span></h4>
                        </div>
                        <button class='rts-btn btn-primary flex-fill text-center' data-bs-toggle='modal' data-bs-target='#packageModal' data-id='{$packageid}'>বিস্তারিত জানুন</button>
                    </div>
                </div>
            </div>
            ";
        }
    ?>
</div>

            <div class="d-flex justify-content-center">
                 <a  style="width:200px;margin-top:20px;" href="#getacall" data-toggle="modal" data-target="#customModal" class="rts-btn btn-primary">Customized Package</a>
                
            </div>
        </div>

        <!-- হজ্জ প্যাকেজ সমূহ Content -->
        <div class="tab-pane fade" id="hajj" role="tabpanel" aria-labelledby="hajj-tab">

           <div class="row gap-5 mt-4">
    <?php
        // Query for Umrah packages
        $sql = "SELECT * FROM package WHERE packageType = 'hajj'";
        $result = $connection->query($sql);
        while ($row = $result->fetch_assoc()) {
            $packageid = $row['packageid'];
            $features_sql = "SELECT description, image FROM packagefeatures WHERE packageid = ?";
            $features_stmt = $connection->prepare($features_sql);
            $features_stmt->bind_param("s", $packageid);
            $features_stmt->execute();
            $features_result = $features_stmt->get_result();
            
            // Assuming 'image' column in 'package' table contains the relative image path
            $imageUrl = 'https://learninghubbd.online/al-waqiah-final/admin/storage/app/public/' . htmlspecialchars($row['image']);
            
            echo "
            <div class='col-lg-6 col-md-6 col-sm-12 w-sm-100 responsive-div'>
                <div class='bg-img' style='background-image: url(\"$imageUrl\");'></div>
                <div class='single-pricing-solari-area'>
                    <span class='pre-title'>" . htmlspecialchars($row['packageName']) . "</span>
                    <div class='days'>৯ <span class='day'>দিন</span></div>
                    <div class='spacer'></div>
                    <hr>
                    <div class='pricing-opportunity-wrapper' style='margin-left:20px'>
            ";

            while ($feature = $features_result->fetch_assoc()) {
                // Full image URL for feature images
                $featureImageUrl = 'https://learninghubbd.online/al-waqiah-final/admin/storage/app/public/' . htmlspecialchars($feature['image']);
                echo "
                    <div class='single d-flex align-items-center' style='margin-bottom: 7px'>
                        <div class='icon-container'>
                            <img src='" . $featureImageUrl . "' alt='Feature image' class='feature-icon' style='height: 21px; width: 21px;' />
                        </div>
                        <p class='packagetxt'>" . htmlspecialchars($feature['description']) . "</p>
                    </div>
                ";
            }

            echo "
                    </div>
                    <div class='m-top-3'>
                        <div class='pricebox mt-3'>
                            <h4 class='title-price'>৳ " . htmlspecialchars($row['price']) . " <span style='color:'#4B5563'>হতে শুরু</span></h4>
                        </div>
                        <button class='rts-btn btn-primary flex-fill text-center' data-bs-toggle='modal' data-bs-target='#packageModal' data-id='{$packageid}'>বিস্তারিত জানুন</button>
                    </div>
                </div>
            </div>
            ";
        }
    ?>
</div>


        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade mt-4" id="packageModal" tabindex="-1" aria-labelledby="packageModalLabel" aria-hidden="true">
    <div class="modal-dialog ">
        <div class="modal-content ">

            <div class="modal-body rounded-top m-0 p-0">

                <div id="modal-content">
                    <p>Loading...</p>
                </div>
            </div>
            <div class="d-flex gap-2">
                <a type="button" class="rts-btn btn-primary flex-fill text-center btn-dark-custom"
                    data-bs-dismiss="modal" aria-label="Close">
                    বন্ধ করুন
                </a>
                <a href="contact.html" class="rts-btn btn-primary flex-fill text-center">বুকিং করুন</a>
            </div>
        </div>

    </div>
</div>

<!-- JavaScript -->

<script>
document.addEventListener("DOMContentLoaded", function() {
    const modal = document.getElementById("packageModal");
    modal.addEventListener("show.bs.modal", function(event) {
        const button = event.relatedTarget;
        const packageId = button.getAttribute("data-id");

        // Fetch package details dynamically
        const xhr = new XMLHttpRequest();
        xhr.open("GET", `getPackageDetails.php?packageid=${packageId}`, true);
        xhr.onload = function() {
            if (xhr.status === 200) {
                document.getElementById("modal-content").innerHTML = xhr.responseText;
            } else {
                document.getElementById("modal-content").innerHTML =
                    "<p>Could not load details.</p>";
            }
        };
        xhr.send();
    });
});
</script>







<!-- our working proces area start -->
<div class="our-working-process-start rts-section-gap">
    <span class="stok-bg images-r">
        Process
    </span>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="title-area-center">
                    <h2 class="title skew-up">
                        আল ওয়াকিয়াহ দিচ্ছে <br> উমরাহ যাত্রার সহজ প্রক্রিয়া
                    </h2>
                </div>
            </div>
        </div>
        <div class="row g-24 mt--20 d-flex justify-content-center">
            <!-- Single Step 1 -->
            <div class="col-lg-3 col-md-3 col-sm-3 col-6">
                <div class="single-solari-steps-start">
                    <div class="thumbnail">
                        <img src="assets/images/steps/0.jpg" alt="step-1">
                        <div class="steps">
                            <span>১</span>
                        </div>
                    </div>
                    <div class="content">
                        <h5 class="title">অনুসন্ধান ও পরামর্শ</h5>
                    </div>
                </div>
            </div>
            <!-- Single Step 2 -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-6">
                <div class="single-solari-steps-start">
                    <div class="thumbnail">
                        <img src="assets/images/steps/1.jpg" alt="step-2">
                        <div class="steps">
                            <span>২</span>
                        </div>
                    </div>
                    <div class="content">
                        <h5 class="title">প্রয়োজনীয় কাজপত্র জমা</h5>
                    </div>
                </div>
            </div>
            <!-- Single Step 3 -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-6">
                <div class="single-solari-steps-start">
                    <div class="thumbnail">
                        <img src="assets/images/steps/3.jpg" alt="step-3">
                        <div class="steps">
                            <span>৩</span>
                        </div>
                    </div>
                    <div class="content">
                        <h5 class="title">ফি পরিশোধ</h5>
                    </div>
                </div>
            </div>
            <!-- Single Step 4 -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-6">
                <div class="single-solari-steps-start">
                    <div class="thumbnail">
                        <img src="assets/images/steps/4.jpg" alt="step-4">
                        <div class="steps">
                            <span>৪</span>
                        </div>
                    </div>
                    <div class="content">
                        <h5 class="title">হজ / উমরাহ পালন</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</div>
</div>
</div>
<!-- our working proces area end -->

<!-- rts feedback area start -->
<div class='rts-feedback-area-solar-energy rts-section-gap' id="getacall">
    <div class='container'>
        <div class='row align-items-center'>
            <div class='col-lg-6'>
                <div class='choose-us-content-left-wrapper-4'>
                    <div class='solari-title-area-four'>
                        <span class='skew-up' style='color:#fff!important;'>বিসমিল্লাহির রাহমানির রাহিম</span>
                        <h6 class='title skew-up bookingtitle'>আপনার স্বপ্নের উমরাহ'র প্রক্রিয়া শুরু করুন এখনই</h6>
                    </div>



                </div>
            </div>
            <div class="col-lg-6">
                <div class="appoinment-area-six-wrapper">
                    <h3 class=" fw-semibold skew-up">
                        কল পেতে আপনার তথ্য প্রদান করুন
                    </h3>
                    <form action="#">
                        <div class="single-input-area">
                            <label for="name">নাম*</label>
                            <input type="text" placeholder="নাম">
                        </div>
                        <div class="single-input-area">
                            <label for="name">মোবাইল নাম্বার*</label>
                            <input type="email" placeholder="মোবাইল নাম্বার">
                        </div>
                        <div class="single-input-area">
                            <label for="name">ঠিকানা</label>
                            <input type="email" placeholder="ঠিকানা ">
                        </div>
                        <div class="single-input-area">
                            <label for="name">বিস্তারিত *</label>
                            <textarea placeholder="বিস্তারিত"></textarea>
                        </div>
                        <button class="rts-btn btn-primary transparent-button">সাবমিট করুন</button>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- rts feedback area end -->
<!-- rts about style four -->
<div class="rts-about-style-four rts-section-gap bg-about-h4 mb--100">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="thumbanil-about-four">
                    <img src="assets/images/about/29.png" alt="about">
                    <div class="small-bottom-right bg_image">
                        <h4 class="title">
                            বিশেষায়িত সেবায় <br>
                            পরিপূর্ন হজ
                        </h4>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl--50 pl_md--15 pl_sm--15 mt_md--50 mt_sm--50">
                <div class="solari-title-area-four">
                    <span class="pre-title skew-up">আল ওয়াকিয়াহ</span>
                    <h2 class="title skew-up">নির্ঝঞ্জাট ব্যবস্থাপনা ও সেবার প্রতিশ্রুতি নিয়ে আল ওয়াকিয়াহ দিচ্ছে উমরাহ
                        প্যাজেক</h2>
                </div>
                <div class="about-inner-four-h4">
                    <p class="disc">
                        বাইতুল্লাহ সফরের বিষয়ে সকলেই বিশ্বস্ত এজেন্সি অনুসন্ধান করে থাকেন৷ ইনশাআল্লাহ! আমরা
                        আল-ওয়াকিয়াহ্‌ দিচ্ছি নভেম্বর মাসে মসৃণ ও সর্বোৎকৃষ্ট সার্ভিসে ইকোনমি, স্ট্যান্ডার্ড,প্রিমিয়াম
                        এবং নিজস্ব পছন্দ অনুযায়ী কাস্টমাইজড লাক্সারি প্যাকেজ।
                    </p>
                    <p class="disc">
                        আমরা বিশ্বাস করি সবার আগে খরচ নয়। সবার আগে ইবাদাত ও সেবা। এই বিশ্বাসে ব্রত হয়ে আমরা স্বল্প খরচের
                        প্যাকেজ দেওয়ার চাইতে সর্বোত্তম সেবা দেওয়ার বিষয়ে মনযোগী এবং এই অনুসারেই আমাদের প্যাকেজগুলো
                        সাজিয়েছি
                    </p>

                    <a href="about.php" class="rts-btn btn-primary">বিস্তারিত জানুন</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- rts about style four end -->




<?php
include 'footer.php';
?>




<!-- JavaScript -->
<script>
// Video Player Functions
const videoContainer = document.getElementById('videoContainer');
const video = document.getElementById('introVideo');

// Function to play video
function playVideo(videoUrl) {
    // Change video source dynamically
    video.src = videoUrl;

    // Show the video container and play the video
    videoContainer.style.display = 'flex';
    video.play();
}

// Function to close video overlay
function closeVideo() {
    videoContainer.style.display = 'none'; // Hide the video container
    video.pause(); // Pause the video
    video.currentTime = 0; // Reset video to the beginning
}
</script>

<!-- CSS -->
<style>
/* Styles for video overlay */
.video-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.8);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

.video-wrapper {
    position: relative;
    width: 80%;
    max-width: 800px;
    background: #000;
    border-radius: 10px;
    overflow: hidden;
}

video {
    width: 100%;
    height: auto;
    display: block;
}

.video-controls {
    position: absolute;
    top: 0px;
    right: 10px;
    background-color: #1C403A;
}

.control-btn {
    background: rgba(255, 255, 255, 0.8);
    border: none;
    padding: 5px 10px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 20px;
}

.close-btn {
    position: absolute;
    top: 10px;
    right: 10px;
    font-size: 30px;
    color: white;
    background: rgba(0, 0, 0, 0.6);
    padding: 5px;
    border-radius: 50%;
    cursor: pointer;
}

.close-btn:hover {
    background: rgba(0, 0, 0, 0.8);
}
</style>
<style>
/* Default width for large devices */
.responsive-div {
    width: 48%;
}

/* Custom Style for Active Tab */
.nav-tabs .nav-link.active {
    background-color: #1C403A;
    /* Change this to the color you want */
    color: white;
    /* Text color when the tab is active */
    border-color: #007bff;
    /* Border color for active tab */
}

/* Optional: Custom hover effect for non-active tabs */
.nav-tabs .nav-link {
    /* Default background for non-active tabs */
    color: rgb(0, 8, 15);
    /* Default text color */

}

.nav-tabs .nav-link:hover {
    /* Hover effect */
}

.nav-tabs li {
    background-color: #e9ecef;
}

/* For small devices (width 576px and below), make it 100% */
@media (max-width: 576px) {
    .responsive-div {
        width: 100%;
    }
}
</style>
<script>

    // JavaScript to handle back button and change route
window.addEventListener('popstate', function (event) {
    if (event.state && event.state.modal) {
        // The modal is open, but now we change the route
        window.location.href = '/new-route';  // Change '/new-route' to your desired path
    }
});

// Listen for modal show event
const videoModals = ['#videoModal1', '#videoModal2', '#videoModal3'];

videoModals.forEach(modalId => {
    const modalElement = document.querySelector(modalId);
    modalElement.addEventListener('show.bs.modal', function () {
        // Push state to history to handle the back button
        history.pushState({ modal: modalId }, '', modalId);
    });
});

</script>