<?php
include_once 'databases.php'; 

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize and validate input data
    $name = htmlspecialchars(trim($_POST['name']));
    $date = htmlspecialchars(trim($_POST['date']));
    $phone = htmlspecialchars(trim($_POST['phone']));
    $airlines = htmlspecialchars(trim($_POST['airlines']));
    $hotel_makka = htmlspecialchars(trim($_POST['hotel_makka']));
    $hotel_madina = htmlspecialchars(trim($_POST['hotel_madina'])); 
    $jiarah = htmlspecialchars(trim($_POST['jiarah']));
    $transport = htmlspecialchars(trim($_POST['transport']));
    $adult = (int) $_POST['adult']; 
    $child = (int) $_POST['child']; 
    $male = (int) $_POST['male'];
    $female = (int) $_POST['female'];
    $food = htmlspecialchars(trim($_POST['food']));

    // Ensure database connection exists
    if (!$connection) {
        die("Database connection failed: " . mysqli_connect_error());
    }

    // Prepare and bind the SQL statement
    $stmt = $connection->prepare("INSERT INTO package_customizations (name, phone, date, airlines, hotel_makka, hotel_madina, jiarah, transport, adult, child, male, female, food) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    if ($stmt) {
        // Bind parameters
        $stmt->bind_param("ssssssssiiiss", $name, $phone, $date, $airlines, $hotel_makka, $hotel_madina, $jiarah, $transport, $adult, $child, $male, $female, $food);

        // Execute the statement
        if ($stmt->execute()) {
            // Redirect after successful submission
            header("Location: index.php");
            exit();
        } else {
            echo "Error: " . $stmt->error;
        }

        // Close statement
        $stmt->close();
    } else {
        echo "Error preparing statement: " . $connection->error;
    }

    // Close the database connection
    $connection->close();
}
?>
