<div class="rts-section-gap">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="solari-title-area-three text-center">
                    <h2 class="title skew-up">প্যাকেজ সমূহ</h2>
                </div>
            </div>
            <!-- Tabs Navigation -->
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="umrah-tab" data-bs-toggle="tab" data-bs-target="#umrah"
                        type="button" role="tab" aria-controls="umrah" aria-selected="true">
                        উমরাহ প্যাকেজ সমূহ
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="hajj-tab" data-bs-toggle="tab" data-bs-target="#hajj" type="button"
                        role="tab" aria-controls="hajj" aria-selected="false">
                        হজ্জ প্যাকেজ সমূহ
                    </button>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content" id="myTabContent">
                <!-- উমরাহ প্যাকেজ সমূহ Content -->
                <div class="tab-pane fade show active" id="umrah" role="tabpanel" aria-labelledby="umrah-tab">
                    <p class="mt-3">এটি উমরাহ প্যাকেজ সমূহের জন্য। এখানে আপনি আপনার পছন্দের উমরাহ প্যাকেজ বেছে নিতে
                        পারবেন।</p>
                    <div class="row gap-5 mt-4">
                        <?php
                        // Query for Umrah packages
                        $sql = "SELECT * FROM package WHERE packageType = 'umrah'";
                        $result = $connection->query($sql);
                        while ($row = $result->fetch_assoc()) {
                            $packageid = $row['packageid'];
                            $features_sql = "SELECT description, image FROM packagefeatures WHERE packageid = ?";
                            $features_stmt = $connection->prepare($features_sql);
                            $features_stmt->bind_param("s", $packageid);
                            $features_stmt->execute();
                            $features_result = $features_stmt->get_result();
                            
                            echo "
                            <div class='col-lg-6 col-md-6 col-sm-12' style='width: 48%;'>
                                <div class='bg-img'>&nbsp;</div>
                                <div class='single-pricing-solari-area'>
                                    <span class='pre-title'>" . htmlspecialchars($row['packageName']) . "</span>
                                    <div class='days'>৯ <span class='day'>দিন</span></div>
                                    <div class='spacer'></div>
                                    <hr>
                                    <div class='pricing-opportunity-wrapper' style='margin-left:20px'>
                            ";

                            while ($feature = $features_result->fetch_assoc()) {
                                echo "
                                    <div class='single d-flex align-items-center' style='margin-bottom: 7px'>
                                        <div class='icon-container'>
                                            <img src='" . htmlspecialchars($feature['image']) . "' alt='Feature image' class='feature-icon' style='height: 21px; width: 21px;' />
                                        </div>
                                        <p class='packagetxt'>" . htmlspecialchars($feature['description']) . "</p>
                                    </div>
                                ";
                            }

                            echo "
                                    </div>
                                    <div class='m-top-3'>
                                        <div class='pricebox mt-3'>
                                            <h4 class='title-price'>৳ " . htmlspecialchars($row['price']) . "থেকে শুরু</h4>
                                        </div>
                                        <a href='#' class='rts-btn btn-primary view-details' data-bs-toggle='modal' data-bs-target='#exampleModal' data-packageid='" . htmlspecialchars($row['packageid']) . "'>বিস্তারিত জানুন </a>
                                    </div>
                                </div>
                            </div>
                        ";
                        }
                        ?>
                    </div>
                </div>

                <!-- হজ্জ প্যাকেজ সমূহ Content -->
                <div class="tab-pane fade" id="hajj" role="tabpanel" aria-labelledby="hajj-tab">
                    <p class="mt-3">এটি হজ্জ প্যাকেজ সমূহের জন্য। এখানে আপনি আপনার পছন্দের হজ্জ প্যাকেজ বেছে নিতে
                        পারবেন।</p>
                    <div class="row gap-5 mt-4">
                        <?php
                        // Query for Hajj packages
                        $sql = "SELECT * FROM package WHERE packageType = 'hajj'";
                        $result = $connection->query($sql);
                        while ($row = $result->fetch_assoc()) {
                            $packageid = $row['packageid'];
                            $features_sql = "SELECT description, image FROM packagefeatures WHERE packageid = ?";
                            $features_stmt = $connection->prepare($features_sql);
                            $features_stmt->bind_param("s", $packageid);
                            $features_stmt->execute();
                            $features_result = $features_stmt->get_result();

                            echo "
                            <div class='col-lg-6 col-md-6 col-sm-12'>
                                <div class='bg-img'>&nbsp;</div>
                                <div class='single-pricing-solari-area'>
                                    <span class='pre-title'>" . htmlspecialchars($row['packageName']) . "</span>
                                    <div class='days'>৯ <span class='day'>দিন</span></div>
                                    <div class='spacer'></div>
                                    <hr>
                                    <div class='pricing-opportunity-wrapper' style='margin-left:20px'>
                            ";

                            while ($feature = $features_result->fetch_assoc()) {
                                echo "
                                    <div class='single d-flex align-items-center' style='margin-bottom: 7px'>
                                        <div class='icon-container'>
                                            <img src='" . htmlspecialchars($feature['image']) . "' alt='Feature image' class='feature-icon' style='height: 21px; width: 21px;' />
                                        </div>
                                        <p class='packagetxt'>" . htmlspecialchars($feature['description']) . "</p>
                                    </div>
                                ";
                            }

                            echo "
                                    </div>
                                    <div class='pricebox'>
                                        <h4 class='title-price'>৳ " . htmlspecialchars($row['price']) . "থেকে শুরু</h4>
                                    </div>
                                    <button class='btn btn-primary' data-bs-toggle='modal' data-bs-target='#packageModal' data-id='{$packageid}'>বিস্তারিত জানুন</button>
                                   
                                </div>
                            </div>
                        ";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="row g-24 pb-10">
                <div class="">
                    <div class="bg-img">&nbsp;</div>
                    <div class="single-pricing-solari-area">
                        <div class="row gap-5 mt-4" id="modal-package-details">
                            <!-- Dynamic content will be inserted here -->
                        </div>

                        <div class="d-flex gap-2" style="margin-right: 18px;">
                            <a type="button" class="rts-btn btn-primary flex-fill text-center btn-dark-custom"
                                data-bs-dismiss="modal" aria-label="Close">
                                বন্ধ করুন
                            </a>
                            <a href="contact.html" class="rts-btn btn-primary flex-fill text-center">বুকিং করুন</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// JavaScript to fetch the package details when clicked and update the modal
document.querySelectorAll('.view-details').forEach(item => {
    item.addEventListener('click', function () {
        let packageId = this.getAttribute('data-packageid');
        
        // Make AJAX request to get package details
        fetch('getPackageDetails.php?id=' + packageId)
            .then(response => response.json())
            .then(data => {
                // Check if data is returned and update modal content
                if (data) {
                    let modalContent = document.getElementById('modal-package-details');
                    modalContent.innerHTML = `
                        <div class="col-lg-6 col-md-6 col-sm-12" style="width: 48%;">
                            <div class="bg-img">&nbsp;</div>
                            <div class="single-pricing-solari-area">
                                <span class="pre-title">${data.packageName}</span>
                                <div class="days">৯ <span class="day">দিন</span></div>
                                <div class="spacer"></div>
                                <hr>
                                <div class="pricing-opportunity-wrapper" style="margin-left:20px">
                                    ${data.features.map(feature => `
                                        <div class="single d-flex align-items-center" style="margin-bottom: 7px">
                                            <div class="icon-container">
                                                <img src="${feature.image}" alt="Feature image" class="feature-icon" style="height: 21px; width: 21px;" />
                                            </div>
                                            <p class="packagetxt">${feature.description}</p>
                                        </div>
                                    `).join('')}
                                </div>
                                <div class="pricebox mt-3">
                                    <h4 class="title-price">৳ ${data.price}থেকে শুরু</h4>
                                </div>
                            </div>
                        </div>
                    `;
                }
            })
            .catch(error => console.error('Error fetching package details:', error));
    });
});
</script>